
/*
 * fbcapi.js - frontend helper for Pixel & CAPI Pro
 */
(function(){
    if(typeof window.fbcapi === 'undefined') window.fbcapi = {};

    function getFbClickId() {
        try {
            var m = document.cookie.match(/(?:^|; )_fbc=([^;]+)/);
            return m ? decodeURIComponent(m[1]) : null;
        } catch(e) {
            return null;
        }
    }

    function fbcapiSendEvent(payload){
        try{
            if(typeof fbcapiRest === 'undefined' || !fbcapiRest.url) return;
            if(!payload) payload = {};
            if(!payload.event_source_url) payload.event_source_url = window.location.href;
            var _fbc = getFbClickId();
            if(_fbc) payload.fbc = _fbc;
            fetch(fbcapiRest.url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json', 'X-WP-Nonce': fbcapiRest.nonce },
                body: JSON.stringify(payload),
                keepalive: true
            }).catch(function(e){ console.warn('FBCAPI send error', e); });
        }catch(e){
            console.error('fbcapiSendEvent error', e);
        }
    }

    function sendOrderEvent(eventName, orderData){
        try{
            var payload = { event_name: eventName, custom_data: orderData || {} };
            var _fbc_val = getFbClickId();
            if(_fbc_val) payload.fbc = _fbc_val;
            fbcapiSendEvent(payload);
        }catch(e){
            console.error('sendOrderEvent error', e);
        }
    }

    window.getFbClickId = getFbClickId;
    window.fbcapiSendEvent = fbcapiSendEvent;
    window.sendOrderEvent = sendOrderEvent;
})();
